:setvar DatabaseName "RegistryQA"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "24"
:setvar DeployVersion "20150223.1"



:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END
GO
USE [$(DatabaseName)];

GO

PRINT 'Step 5 - Registry.Database.DropConstraints.sql
Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)
BUILD $(DeployVersion)
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

 ';
GO

DECLARE @FullObjectName varchar(200);


PRINT 'Drop Constraints...';    

SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(parent.name)) +']'
                                 + ' DROP CONSTRAINT [' + LTRIM(RTRIM(objects.name)) +']'
                             FROM sys.objects
                             JOIN sys.schemas
                               ON objects.schema_id = schemas.schema_id
                             JOIN sys.objects parent
                               on Objects.parent_object_id = parent.object_id
                            WHERE schemas.name = 'AHOBPR'
                            AND objects.type = N'F' 
                         ORDER BY schemas.name, objects.name
                         );
                         
WHILE @FullObjectName IS NOT NULL
BEGIN
  PRINT 'Alter Table ' + @FullObjectName;
  EXECUTE('ALTER TABLE ' + @FullObjectName );

  SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(parent.name)) +']'
                                 + ' DROP CONSTRAINT [' + LTRIM(RTRIM(objects.name)) +']'
                             FROM sys.objects
                             JOIN sys.schemas
                               ON objects.schema_id = schemas.schema_id
                             JOIN sys.objects parent
                               on Objects.parent_object_id = parent.object_id
                            WHERE schemas.name = 'AHOBPR'
                            AND objects.type = N'F' 
                         ORDER BY schemas.name, objects.name
                         );
END;
                                   
PRINT 'Write to DatabaseChangeLog...';
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Step 5 - Registry.Database.DropConstraints.sql'
	   ,'AHOBPR 1.0.24 Deployment'
           ,'AHOBPR'
           ,GETDATE());
GO

PRINT '';
PRINT 'Step 5 - Registry.Database.DropConstraints.sql Complete.';
PRINT '';
PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';
GO                                 